package GraphicThreads;

import javafx.application.Platform;
import UI.MyPane;
import java.io.Serializable;

import Back.Node;



public class MoveThread<T extends Serializable & Comparable<T> > extends GraphicThread {
    T which_v, where_v;

    public MoveThread(MyPane<T> _pane, String _where, String _which ) {
        pane = _pane;
        tree = pane.getTree1();
        SLEEP_TIME = 1000;
        where_v = (T) (_where);
        which_v = (T) (_which);
    }


    @Override
    public void run() {
        Node<T> which = threadFindByNode(tree.getRoot(), new Node(which_v, null) );
        if ( which != null ) {
            which.setFind(false);
            which.setAdd(true);
            updateTree();
        }


        Node<T> where = threadFindByNode(tree.getRoot(), new Node(where_v, null) );
        if ( where != null ) {
            where.setFind(false);
            where.setAdd(true);
            updateTree();
        }

        if ( where == null || which == null ){
            Platform.runLater(() -> {
                pane.end();
            });
            return;
        }


        threadRemove(tree.getRoot(), which);
        updateTree();
        where.insertNode(-1, which);
        updateTree();


        Platform.runLater(() -> {
            pane.end();
        });

    }



}
